﻿; -----------------------------------------------------------------
;  FileDate - with date picker,  designed for SendTo
;  change file date (last written);  time remains unchanged
; -----------------------------------------------------------------
#title = "File Date"
#version = " ver. 1.1"  ; Unicode
#error = "One(!) file expected"
#action = "Change"

FilePath.s = ProgramParameter()
If FilePath And ProgramParameter() = ""  ; one and only one
Else : MessageBox_(0,#error,#title+#version,0) : End 
EndIf   

#SecondsInDay = 24*60*60
OriginalDate = GetFileDate(FilePath,#PB_Date_Modified)
OriginalTime = OriginalDate % #SecondsInDay

#Input = 1
#Button = 2
OpenWindow(0,DesktopMouseX(),DesktopMouseY(),180,35,#title,#PB_Window_SystemMenu)
DateGadget(#Input,10,5,100,25,"",OriginalDate) 
ButtonGadget(#Button,120,5,50,25,#action)
GadgetToolTip(#Button,FilePath)
StickyWindow(0,1)

Repeat 
  event = WaitWindowEvent()
  If event = #PB_Event_Gadget 
    If EventGadget() = #Button
      newDate = GetGadgetState(#Input) 
      newDate = (newDate / #SecondsInDay) * #SecondsInDay + OriginalTime
      SetFileDate(FilePath,#PB_Date_Modified,newDate)
      exit = #True
    EndIf 
  ElseIf event = #PB_Event_CloseWindow
    exit = #True
  EndIf     
Until exit

End


; IDE Options = PureBasic 4.61 (Windows - x86)
; CursorPosition = 5
; EnableUnicode
; EnableXP
; UseIcon = calendar.ico
; Executable = FileDate.exe
; DisableDebugger
; CommandLine = test.txt
; CompileSourceDirectory