﻿; PureBasic source (c) 2008-2012, Horst Schaeffer
; command argument: absolute path 
; default msg box: default sound, no icon
; options: /i (bubble icon), /m (no sound, no icon) /f (prompt: open folder?)

#title = "PathLen"       ; unicode
#version = " 1.6"        ; trailing backslases (win7 issue), explorer: select file, option /c
InitCommonControls_()

Procedure GetLongestPath(relDirPath.s,level=0)   ; recursive, base initially: current dir ("")
  Shared LongestRelPath.s, PathsChecked 
  If ExamineDirectory(level,relDirPath,"*.*")
    While NextDirectoryEntry(level)
      type = DirectoryEntryType(level)
      name.s = DirectoryEntryName(level)
      If name <> "." And name <> ".."
        PathsChecked +1
        path$ = relDirPath + name
        If Len(path$) > Len(LongestRelPath) 
          LongestRelPath = path$ 
        EndIf 
        If type = #PB_DirectoryEntry_Directory 
          GetLongestPath(path$+"\",level+1)
        EndIf 
      EndIf 
    Wend  
  EndIf 
EndProcedure 

Repeat 
  string$ = ProgramParameter()
  If string$ 
    If Left(string$,1) = "/"
      option$ = LCase(Mid(string$,2,1))   ; only 1st char checked 
      If option$ = "i"     : option = #MB_ICONINFORMATION
      ElseIf option$ = "m" : option = #MB_ICONINFORMATION | $80
      ElseIf option$ = "n" : NoFolderPrompt = #True 
      ElseIf option$ = "c" : ToClipboard = #True 
      EndIf 
    Else : BasePath.s = string$
    EndIf 
  EndIf 
Until string$ = ""

If BasePath
  If GetFileAttributes(BasePath) & #FILE_ATTRIBUTE_DIRECTORY
    If SetCurrentDirectory(BasePath) 
      GetLongestPath("")
      If LongestRelPath 
        If Right(BasePath,1) <> "\" : BasePath + "\" : EndIf 
        Header$ = "Longest of " +Str(PathsChecked) + " paths:" + #CR$ +#CR$
      EndIf 
    EndIf 
  EndIf 
  FullPath.s = BasePath + LongestRelPath    ; (if a file was given, LongestRelPath = "")
  
  If ToClipboard
    SetClipboardText(FullPath) ; (GetPathPart(FullPath))  
  EndIf 
  
  Display$ = Header$ + ReplaceString(FullPath,"\","\"+#CR$) +#CR$ +#CR$ +Str(Len(FullPath)) +" characters"
  If NoFolderPrompt 
    prompt = #MB_OK
  Else 
    Display$ +#CR$ +#CR$ + "Open Folder (Explorer)?" 
    prompt = #MB_YESNO
  EndIf 
Else 
  Display$ = "Drag&drop a path on [shortcut to] executable" 
  ver$ = #version
EndIf 

response = MessageBox_(0,Display$,#title+ver$,prompt|option)
If response = #IDYES
  ; ShellExecute_(0,"explore",GetPathPart(FullPath),0,0,#SW_SHOW)
  ShellExecute_(0,"open","Explorer.exe","/Select," + FullPath,0,#SW_SHOWNORMAL)
EndIf 
End

; IDE Options = PureBasic 4.61 (Windows - x86)
; CursorPosition = 6
; Folding = -
; EnableUnicode
; EnableXP
; UseIcon = structure.ico
; Executable = pathlen.exe
; CommandLine = "E:\Programming\PureBasic\Projects\div\misc" /i
; CompileSourceDirectory